unit hs_zp3Bi;
{$N+}

Interface

uses windows, sysutils;


{*** Ldt den Treiber und prft ob Zhlerkarte vorhanden. "0", wenn vorhanden.
 *** Alles auf Basisebene*}
Function HS_ZP3B_Init
(      CardNo               :longint){Nr der Karte}
:longint
; stdcall


{*** berprft die Version von Hardwaretreiber und DLL auf Basisebene ***}
Function HS_ZP3B_GetVersion
(      DriverVersion: pchar;  {Version des Kartentreibers}
       DllVersion: pchar)    {Version des Basis-DLL }
:longint
; stdcall


{*** Holt Zhlerwerte und Status einer Achse der Zhlerkarte auf Basisebene ***}
Function HS_ZP3B_ReadCounter
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       var Count            :longint; {Zhlerwert der Achse mit CounterNo}
       var Status           :longint) {Status der Achse mit CounterNo}
:longint
; stdcall



{*** Holt Zhlerwerte und Status aller Achsen der Zhlerkarte auf Basisebene***}
Function HS_ZP3B_ReadAllCounter
(      CardNo               :longint; {Nr der Karte}
       var Count1           :longint; {Zhlerwert der 1. Achse mit CounterNo}
       var Status1          :longint; {Status der 1. Achse mit CounterNo}
       var Count2           :longint; {Zhlerwert der 2. Achse mit CounterNo}
       var Status2          :longint; {Status der 2. Achse mit CounterNo}
       var Count3           :longint; {Zhlerwert der 3. Achse mit CounterNo}
       var Status3          :longint) {Status der 3. Achse mit CounterNo}
:longint
; stdcall

{*** Setzt den Referenzmodus einer Achse ***}
Function HS_ZP3B_SetRefMode
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       RefMode              :longint) {Referenzmodus Zhler}
:longint
; stdcall


{*** Stoppt alle Zhler aller Karten ***}
Function HS_ZP3B_StopAllCounter
(      CardNo               :longint) {Nr der Karte}
:longint
; stdcall

{*** Setzt die I2C-Clock Leitung einer Achse ***}
Function HS_ZP3B_I2C_SetClock
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       Val                  :longint) {Pegel der I2C-Clock Leitung}
:longint
; stdcall

{*** Setzt die I2C-Daten Leitung einer Achse ***}
Function HS_ZP3B_I2C_SetData
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       Val                  :longint) {Pegel der I2C-Daten Leitung}
:longint
; stdcall

{*** Liest die I2C-Daten Leitung einer Achse ***}
Function HS_ZP3B_I2C_GetData
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       var Val              :longint) {Pegel der I2C-Daten Leitung}
:longint
; stdcall

{*** Lst ein Stopp-Signal aus ***}
Function HS_ZP3B_Stop
(      CardNo               :longint) {Nr der Karte}
:longint
; stdcall

{*** Zhler-Stopp-Matrix konfigurieren ***}
Function HS_ZP3B_SetStopCnf
(      CardNo               :longint; {Nr der Karte}
       StopOut              :longint; {Stopp-Ausgang}
       StopIn               :longint) {Stopp-Eingang}
:longint
; stdcall



Implementation
function HS_ZP3B_Init;			    external 'HS_ZP3B.DLL' name  'HS_ZP3B_Init';
function HS_ZP3B_ReadCounter;		external 'HS_ZP3B.DLL' name  'HS_ZP3B_ReadCounter';
function HS_ZP3B_ReadAllCounter;	external 'HS_ZP3B.DLL' name  'HS_ZPBX_ReadAllCounter';
Function HS_ZP3B_GetVersion;		external 'HS_ZP3B.DLL' name  'HS_ZPBX_GetVersion';
Function HS_ZP3B_SetRefMode;		external 'HS_ZP3B.DLL' name  'HS_ZP3B_SetRefMode';
Function HS_ZP3B_StopAllCounter;	external 'HS_ZP3B.DLL' name  'HS_ZP3B_StopAllCounter';
Function HS_ZP3B_I2C_SetClock;	    external 'HS_ZP3B.DLL' name  'HS_ZP3B_I2C_SetClock';
Function HS_ZP3B_I2C_SetData;	    external 'HS_ZP3B.DLL' name  'HS_ZP3B_I2C_SetData';
Function HS_ZP3B_I2C_GetData;	    external 'HS_ZP3B.DLL' name  'HS_ZP3B_I2C_GetData';
Function HS_ZP3B_Stop;	            external 'HS_ZP3B.DLL' name  'HS_ZP3B_Stop';
Function HS_ZP3B_SetStopCnf;	    external 'HS_ZP3B.DLL' name  'HS_ZP3B_SetStopCnf';
begin
end.
